var glenz_model,
	glenz_otherBuffers,
	glenz_otherBufferIndex,
	glenz_previousAmplitudeMax

function glenz_init()
{
	glenz_otherBufferIndex	= 0
	glenz_previousAmplitudeMax =0

	//	create a bunch of otherBuffers
	glenz_otherBuffers		= []

	for( var i=0; i<64; i++ )
	{
		glenz_otherBuffers[i]			= document.createElement('canvas')
		glenz_otherBuffers[i].width		= 320
		glenz_otherBuffers[i].height	= 160
	}

	//	create mesh
	glenz_model = new Model()

	var	n=13;
	glenz_model.vertices =
	[
		{x: 8,y: 8,z: 8},	{x:-8,y: 8,z: 8},	{x:-8,y:-8,z: 8},	{x: 8,y:-8,z: 8},
		{x: 8,y: 8,z:-8},	{x:-8,y: 8,z:-8},	{x:-8,y:-8,z:-8},	{x: 8,y:-8,z:-8},
		{x: 0,y: 0,z: n},	{x: 0,y: 0,z:-n},	{x: 0,y: n,z: 0},	{x: 0,y:-n,z: 0},	{x: n,y: 0,z: 0},	{x:-n,y: 0,z: 0}
	]
	glenz_model.faces =
	[
		{ color:0, a:0,b:1,c:8 	},	{ color:0, a:2,b:3,c:8	},	{ color:1, a:1,b:2,c:8 	},	{ color:1, a:3,b:0,c:8	},
		{ color:0, a:5,b:4,c:9 	},	{ color:0, a:7,b:6,c:9	},	{ color:1, a:6,b:5,c:9 	},	{ color:1, a:4,b:7,c:9	},
		{ color:0, a:0,b:3,c:12 },	{ color:0, a:7,b:4,c:12 },	{ color:1, a:4,b:0,c:12 },	{ color:1, a:3,b:7,c:12 },
		{ color:0, a:2,b:1,c:13 },	{ color:0, a:5,b:6,c:13 },	{ color:1, a:1,b:5,c:13 },	{ color:1, a:6,b:2,c:13 },
		{ color:1, a:1,b:0,c:10 },	{ color:1, a:4,b:5,c:10 },	{ color:0, a:5,b:1,c:10 },	{ color:0, a:0,b:4,c:10 },
		{ color:1, a:3,b:2,c:11 },	{ color:1, a:6,b:7,c:11 },	{ color:0, a:2,b:6,c:11 },	{ color:0, a:7,b:3,c:11 }
	]
	//	done
	progressBarIndex++;
}


function glenz_render( currentTime, percentage, extraArguments )
{


	var an = percentage*Math.PI
	glenz_model.colors =
	[
		'rgba('+Math.round(95+95*Math.cos(an+=Math.PI*2/3))+','+Math.round(95+95*Math.cos(an+=Math.PI*2/3))+','+Math.round(95+95*Math.cos(an+=Math.PI*2/3))+',0.5)'
		,'rgba('+Math.round(127+127*Math.cos(an+=Math.PI*2/3))+','+Math.round(127+127*Math.cos(an+=Math.PI*2/3))+','+Math.round(127+127*Math.cos(an+=Math.PI*2/3))+',0.5)'
		,'rgb(255,255,255)'
	]

	var	camera		= {x:2*Math.cos(percentage*Math.PI/2),y:2*Math.cos(percentage*Math.PI/3),z:-48},
		angles		= {x:percentage*Math.PI*0.47,y:percentage*Math.PI*0.61,z:percentage*Math.PI*0.43},
		fovAngle	= Math.PI/6

	//	fountain
	glenz_model.rotateAndProject(
		angles,
		camera,
		160, 80, fovAngle
	)


	var currentBufferContext = glenz_otherBuffers[ glenz_otherBufferIndex%glenz_otherBuffers.length ].getContext('2d');
	currentBufferContext.clearRect( 0,0,320,160 );

	glenz_model.sortFaces();

	for( var i=0,p; p=glenz_model.faces[i]; i++ )
	{
		if( p.zn<0 )
			glenz_model.drawTriangle( currentBufferContext, p )
		else if( p.color )
			glenz_model.drawTriangle( currentBufferContext, p, 1 )
	}



//	offScreenCanvasContext.clearRect( 0,0,320,160 );
	offScreenCanvasContext.drawImage( backgrounds_red[ 4+(Math.floor(percentage*8)&3)], 0,0 )

	// blit
	var amplitudeMax = Math.max(0, Math.min(glenz_otherBufferIndex,glenz_otherBuffers.length-1) )


	glenz_previousAmplitudeMax = amplitudeMax

	an = percentage*Math.PI/4
	for( var i=0;i<160;i++ )
	{
		var whichBuffer = (glenz_otherBufferIndex-Math.min( amplitudeMax, Math.round( amplitudeMax/2+amplitudeMax/2*Math.cos(an+i*.02) )  ))%glenz_otherBuffers.length
		offScreenCanvasContext.drawImage( glenz_otherBuffers[whichBuffer], 0,i,320,1,0,i,320,1 )
	}


	if( extraArguments )
		glenz_otherBufferIndex++
}
